<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RentalCars extends Model 
{

    protected $table = 'rental_cars';
    public $timestamps = true;
    protected $fillable = array('id', 'brand_id', 'type', 'model', 'color', 'daily_rental', 'weekly_rental', 'monthly_rental', 'yearly_rent', 'active', 'availablity', 'rental_office_id', 'timestamps');

    public function rental_office()
    {
        return $this->belongsTo('App\Models\RentalOffice');
    }

    public function rental_car_reservation()
    {
        return $this->hasOne('App\Models\RentalCarsReservation');
    }

}